#!/bin/bash

echo "Erişim Kontrol Sistemi Deploy Script'i"
echo "======================================"

# Sistem güncellemelerini kontrol et
echo "Sistem güncellemeleri kontrol ediliyor..."
sudo apt-get update

# Gerekli paketleri yükle
echo "Gerekli paketler yükleniyor..."
sudo apt-get install -y docker.io docker-compose nginx

# Docker servisini başlat
echo "Docker servisi başlatılıyor..."
sudo systemctl start docker
sudo systemctl enable docker

# Nginx konfigürasyonunu kopyala
echo "Nginx konfigürasyonu ayarlanıyor..."
sudo cp nginx.conf /etc/nginx/sites-available/access-server
sudo ln -sf /etc/nginx/sites-available/access-server /etc/nginx/sites-enabled/
sudo rm -f /etc/nginx/sites-enabled/default

# Nginx'i yeniden başlat
sudo systemctl restart nginx
sudo systemctl enable nginx

# Firewall ayarları
echo "Firewall ayarları yapılıyor..."
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp
sudo ufw allow 22/tcp

# Docker Compose ile uygulamayı başlat
echo "Uygulama Docker ile başlatılıyor..."
sudo docker-compose up -d --build

echo "Deploy tamamlandı!"
echo "Uygulama http://$(curl -s ifconfig.me) adresinde çalışıyor"
echo "Logları görmek için: sudo docker-compose logs -f" 