#!/usr/bin/env python3
import sqlite3

def clear_rs485_logs():
    conn = sqlite3.connect('data.db')
    cursor = conn.cursor()
    
    print("RS485 mock access log'lar temizleniyor...")
    
    # RS485 access type = 6 olan kayıtları sil
    cursor.execute('DELETE FROM access_logs WHERE access_type = 6')
    deleted_count = cursor.rowcount
    
    # RS485 device ID'leri ile başlayan kayıtları da sil
    cursor.execute("DELETE FROM access_logs WHERE device_id LIKE 'RS485_%'")
    deleted_count_2 = cursor.rowcount
    
    conn.commit()
    conn.close()
    
    print(f"Toplam {deleted_count + deleted_count_2} RS485 log silindi!")
    print("RS485 mock access log'lar başarıyla temizlendi!")

if __name__ == "__main__":
    clear_rs485_logs() 