# Erişim Kontrol Sistemi - Deploy Talimatları

Bu doküman, Erişim Kontrol Sistemi'ni uzak sunucuya deploy etme adımlarını içerir.

## Gereksinimler

- Ubuntu 20.04 veya üzeri
- Root veya sudo yetkisi
- İnternet bağlantısı

## Hızlı Deploy (Otomatik)

1. Proje dosyalarını sunucuya yükleyin:
```bash
# Yerel bilgisayarınızdan
scp -r ./* kullanici@sunucu_ip:/home/kullanici/access-server/
```

2. Sunucuya bağlanın:
```bash
ssh kullanici@sunucu_ip
cd /home/kullanici/access-server
```

3. Deploy script'ini çalıştırın:
```bash
./deploy.sh
```

## Manuel Deploy

### 1. Sistem Hazırlığı

```bash
# Sistem güncellemeleri
sudo apt-get update && sudo apt-get upgrade -y

# Gerekli paketler
sudo apt-get install -y docker.io docker-compose nginx curl
```

### 2. Docker Kurulumu

```bash
# Docker servisini başlat
sudo systemctl start docker
sudo systemctl enable docker

# Kullanıcıyı docker grubuna ekle
sudo usermod -aG docker $USER
```

### 3. Nginx Konfigürasyonu

```bash
# Nginx konfigürasyonunu kopyala
sudo cp nginx.conf /etc/nginx/sites-available/access-server
sudo ln -sf /etc/nginx/sites-available/access-server /etc/nginx/sites-enabled/
sudo rm -f /etc/nginx/sites-enabled/default

# Nginx'i yeniden başlat
sudo systemctl restart nginx
sudo systemctl enable nginx
```

### 4. Firewall Ayarları

```bash
# Gerekli portları aç
sudo ufw allow 80/tcp
sudo ufw allow 443/tcp
sudo ufw allow 22/tcp
sudo ufw --force enable
```

### 5. Uygulamayı Başlat

```bash
# Docker Compose ile başlat
sudo docker-compose up -d --build
```

## Docker Compose ile Deploy

```bash
# Uygulamayı başlat
docker-compose up -d

# Logları kontrol et
docker-compose logs -f

# Uygulamayı durdur
docker-compose down
```

## Manuel Docker Deploy

```bash
# Docker image'ı oluştur
docker build -t access-server .

# Container'ı çalıştır
docker run -d \
  --name access-server \
  -p 5000:5000 \
  -p 80:80 \
  -p 8080:8080 \
  -v $(pwd)/data.db:/app/data.db \
  -v $(pwd)/logs:/app/logs \
  access-server
```

## SSL Sertifikası (Opsiyonel)

Let's Encrypt ile SSL sertifikası eklemek için:

```bash
# Certbot kurulumu
sudo apt-get install -y certbot python3-certbot-nginx

# SSL sertifikası al
sudo certbot --nginx -d your-domain.com

# Otomatik yenileme
sudo crontab -e
# Aşağıdaki satırı ekle:
# 0 12 * * * /usr/bin/certbot renew --quiet
```

## Monitoring ve Loglar

```bash
# Uygulama logları
docker-compose logs -f access-server

# Nginx logları
sudo tail -f /var/log/nginx/access.log
sudo tail -f /var/log/nginx/error.log

# Sistem kaynakları
docker stats
```

## Backup ve Restore

### Veritabanı Yedekleme

```bash
# Yedek al
cp data.db data.db.backup.$(date +%Y%m%d_%H%M%S)

# Yedekten geri yükle
cp data.db.backup.20231201_120000 data.db
```

### Tam Sistem Yedekleme

```bash
# Tüm proje dosyalarını yedekle
tar -czf access-server-backup-$(date +%Y%m%d).tar.gz \
  --exclude='*.pyc' \
  --exclude='__pycache__' \
  --exclude='.git' \
  .
```

## Sorun Giderme

### Port Çakışması

```bash
# Hangi portların kullanıldığını kontrol et
sudo netstat -tulpn | grep :80
sudo netstat -tulpn | grep :5000

# Gerekirse servisleri durdur
sudo systemctl stop apache2  # Apache varsa
```

### Docker Sorunları

```bash
# Docker servisini yeniden başlat
sudo systemctl restart docker

# Container'ları temizle
docker system prune -a

# Image'ları yeniden oluştur
docker-compose build --no-cache
```

### Nginx Sorunları

```bash
# Nginx konfigürasyonunu test et
sudo nginx -t

# Nginx'i yeniden başlat
sudo systemctl restart nginx

# Nginx durumunu kontrol et
sudo systemctl status nginx
```

## Güvenlik Önerileri

1. **Firewall**: Sadece gerekli portları açın
2. **SSL**: HTTPS kullanın
3. **Güncellemeler**: Düzenli sistem güncellemeleri yapın
4. **Backup**: Düzenli yedekleme yapın
5. **Monitoring**: Sistem kaynaklarını izleyin

## Destek

Sorun yaşarsanız:
1. Logları kontrol edin
2. Sistem kaynaklarını kontrol edin
3. Docker container durumunu kontrol edin
4. Nginx konfigürasyonunu test edin 