/**
 * @brief ServerData.c
 * @author muratdemirtastr@gmail.com
 */
 #include "../Application.h"
 #include "../Settings/Settings.h"
 #include "BSP_ESP32/InternalFlash/esp32_internal_flash.h"
 #include "Application/JSON/parson.h"
 #include "BSP_ESP32/Ethernet/ethernet_esp32.h"
 #include "BSP_ESP32/RFID/bsp_mfrc522.h"
 #include "BSP_ESP32/WiFi/bsp_wifi.h"
 #include "BSP_ESP32/BSP/bsp_pins.h"
 #include "BSP_ESP32/I2CBus/i2c_esp32.h"
 #include "BSP_ESP32/System/resets.h"
 static char float_str[100];
 static char ip_str[30];
 /**
  *
  * @param
  * @return
  */
  char *Float2Str(double var){
     /* clear float to str buffer*/
     memset(float_str, '\0', sizeof(float_str));
     /* print float value */
     snprintf(float_str, sizeof(float_str), "%.2f", var);
     /* return string*/
     return float_str;
 }
 /**
 * Function for converting ip address to char pointer
 * @param ip target ip address
 * @return char pointer of ip address
 */
 char* IP2STR(uint8_t ip[]){
     /* clear ip address pointer */
     memset(ip_str, 0, sizeof(ip_str));
     /* print ip address into string*/
     snprintf(ip_str, sizeof(ip_str) , "%d.%d.%d.%d", ip[0], ip[1],ip[2],ip[3]);
     /* return ip string */
     return ip_str;
 }
 /**
  *
  * @param qos
  * @param topic
  * @param device_id
  * @param type
  */
 void Application_Collect_Device_Data(char data_buf[]){
      /* check value */
     int32_t intValue = 0;
     /* set json init value*/
     JSON_Value *root_value = json_value_init_object();
     /* set json root value*/
     JSON_Object *root_object = json_value_get_object(root_value);
 
     BSP_RFID_Debug();
     
     json_object_set_string(root_object, "type", "getdeviceinfo");
     /* set rtc timestamp */
     json_object_set_string(root_object, "timestamp", rtc_handler.device_rtc);
     /* id yolla */
     json_object_set_string(root_object, "deviceid", (char*)start_data.device_id);
     /* system version info value*/
     json_object_set_string(root_object, "version", APP_VERSION);
     
     json_object_set_boolean(root_object, "isTerminal", (device_settings.terminalMode == 222) ? 1 : 0);
 
     if(device_settings.wifiSettings.setFlag == 222){
         json_object_set_string(root_object, "wifissid", device_settings.wifiSettings.ssid);
         json_object_set_string(root_object, "wifipasswd", device_settings.wifiSettings.ssid_password);
     }else{
         json_object_set_string(root_object, "wifissid", "");
         json_object_set_string(root_object, "wifipasswd", "");
     }
 
     json_object_set_boolean(root_object, "usingBackup", (device_settings.backupUsed == 222) ? 1 : 0);
     if(device_settings.backupUsed == 222){
         json_object_set_number(root_object, "backupusedsince", device_settings.backupUseTimestamp);
     }
     json_object_set_number(root_object, "deviceErrors", start_data.deviceErrors);
     json_object_set_number(root_object, "logSize", start_data.logSize / sizeof(ts_notify_task_queue_t));
     json_object_set_number(root_object, "logFileSize", start_data.logSize  );
     /* system version info value*/
     json_object_set_number(root_object, "resetCause", start_data.reset_cause);
     json_object_set_number(root_object, "resetCount", BSP_RCM_getResetCount());
     json_object_set_number(root_object, "heapfree", xPortGetFreeHeapSize());
      json_object_set_number(root_object, "ledBrightness", device_settings.ledBrightness);
     json_object_set_number(root_object, "rs485Baudrate", device_settings.rs485Baudrate);
     json_object_set_number(root_object, "ratelimit", device_settings.accessRateLimit);	
 
     if(device_settings.masterCardSet == 222){
         json_object_set_number(root_object, "mastercarduuid", device_settings.masterCardUid);
     }else{
         json_object_set_number(root_object, "mastercarduuid",  UINT32_MAX);
     }
     if(device_settings.remoteIpSet == 222){
         json_object_set_string(root_object,"remotetarget", device_settings.remoteIpAddr);
     }else{
         json_object_set_string(root_object,"remotetarget", "gecis.mdsoftwarehouse:8080");
     }
     
     json_object_set_value(root_object, "rfidInfo", json_value_init_array());
     JSON_Array * rfidInfo = json_object_get_array(root_object, "rfidInfo");
     json_array_append_number(rfidInfo,  start_data.activeRFIDCount);
     json_array_append_number(rfidInfo,  start_data.passiveRFIDCount);
     json_array_append_number(rfidInfo,  start_data.totalRFIDCount);
 
     if(start_data.inputState1 == 222){
         intValue |= 0x01;
     }
     if(start_data.inputState2 == 222){
         intValue |= 0x02;
     }
     
     json_object_set_number(root_object, "inputs", intValue);
  
     json_object_set_value(root_object, "relay1", json_value_init_array());
     JSON_Array * relay1_info = json_object_get_array(root_object, "relay1");
     json_array_append_number(relay1_info,  device_settings.accessDevs[0].access_mode);
     json_array_append_number(relay1_info,  device_settings.accessDevs[0].triggerTimeout);
     
     json_object_set_value(root_object, "relay2", json_value_init_array());
     JSON_Array * relay2_info = json_object_get_array(root_object, "relay2");
     json_array_append_number(relay2_info,  device_settings.accessDevs[1].access_mode);
     json_array_append_number(relay2_info,  device_settings.accessDevs[1].triggerTimeout);
         
     json_object_set_value(root_object, "input1", json_value_init_array());
     JSON_Array * input1_info = json_object_get_array(root_object, "input1");
     json_array_append_number(input1_info,  device_settings.accessInputDev[0].accessInputMode);
     json_array_append_number(input1_info,  device_settings.accessInputDev[0].accessInputPolarity);
     json_array_append_number(input1_info,  device_settings.accessInputDev[0].accessInputCounter);
     
     json_object_set_value(root_object, "input2", json_value_init_array());
     JSON_Array * input2_info = json_object_get_array(root_object, "input2");
     json_array_append_number(input2_info,  device_settings.accessInputDev[1].accessInputMode);
     json_array_append_number(input2_info,  device_settings.accessInputDev[1].accessInputPolarity);
     json_array_append_number(input2_info,  device_settings.accessInputDev[1].accessInputCounter);
         
  
     /* check activation flag */
     if(device_settings.ethStaticCFG.active == 222){
         /* init array and get */
         json_object_set_value(root_object, "ethstatic", json_value_init_array());
         JSON_Array * wifi_info_array = json_object_get_array(root_object, "ethstatic");
         /* fill static ip variables */
         json_array_append_string(wifi_info_array,  device_settings.ethStaticCFG.ip_addr);
         json_array_append_string(wifi_info_array,  device_settings.ethStaticCFG.netmask);
         json_array_append_string(wifi_info_array,  device_settings.ethStaticCFG.gw_addr);
         json_array_append_string(wifi_info_array,  device_settings.ethStaticCFG.dns);
     }else{
         /* init array and get */
         json_object_set_value(root_object, "ethdhcp", json_value_init_array());
         JSON_Array * eth_info_array = json_object_get_array(root_object, "ethdhcp");
         /* fill dhcp variables */
         json_array_append_string(eth_info_array, IP2STR(ethInfo.ipAddress));
         json_array_append_string(eth_info_array, IP2STR(ethInfo.gateWayAddress));
         json_array_append_string(eth_info_array, IP2STR(ethInfo.netmask));
         json_array_append_string(eth_info_array, start_data.macBufferETH);
     }
  
     /* check static ip is activated */
     if(device_settings.wifiStaticCFG.active == 222){
         /* init array and get */
         json_object_set_value(root_object, "wifistatic", json_value_init_array());
         JSON_Array * wifi_info_array = json_object_get_array(root_object, "wifistatic");
         /* fill static ip variables */
         json_array_append_string(wifi_info_array,  device_settings.wifiStaticCFG.ip_addr);
         json_array_append_string(wifi_info_array,  device_settings.wifiStaticCFG.netmask);
         json_array_append_string(wifi_info_array,  device_settings.wifiStaticCFG.gw_addr);
         json_array_append_string(wifi_info_array,  device_settings.wifiStaticCFG.dns);
     }else{
         /* init array and get */
         json_object_set_value(root_object, "wifidhcp", json_value_init_array());
         JSON_Array * wifi_info_array = json_object_get_array(root_object, "wifidhcp");
         /* fill dhcp variables */
         json_array_append_string(wifi_info_array, IP2STR(wifiInfo.ipAddress));
         json_array_append_string(wifi_info_array, IP2STR(wifiInfo.gateWayAddress));
         json_array_append_string(wifi_info_array, IP2STR(wifiInfo.netmask));
         json_array_append_string(wifi_info_array, start_data.macBufferWifi);
     }
  
     /* json string to buffer*/
     json_serialize_to_buffer(root_value, data_buf, sizeof(deviceResponseBuffer));
     /* free json malloc*/
     json_value_free(root_value);
 }
 /**
  * Collect JSON alarm data
  * @param data_buf destinaiion buffer
  * @param size destination buffer size
  */
 void Application_Collect_Alarm_Data(char data_buf[], int32_t size){
     /* int value */
     int32_t	intValue = 0;
     /* set json init value*/
     JSON_Value *root_value = json_value_init_object();
     /* set json root value*/
     JSON_Object *root_object = json_value_get_object(root_value);
 
     json_object_set_string(root_object, "deviceid", start_data.device_id);
     /* check alarm state */
     if(device_settings.alarmInput1State == 222){
         intValue |= 0x01;
         json_object_set_number(root_object, "alarmtime1", device_settings.alarmInput1StateTime);
     }
     /* check alarm state */
     if(device_settings.alarmInput2State == 222){
         intValue |= 0x02;
         json_object_set_number(root_object, "alarmtime2", device_settings.alarmInput2StateTime);
     }
     /* set device id*/
     json_object_set_number(root_object, "alarm", intValue);
     json_object_set_number(root_object, "timestamp", rtc_handler.timeStamp);
     json_object_set_number(root_object, "errors", start_data.deviceErrors);
     /* clear buffer*/
     /* json string to buffer*/
     json_serialize_to_buffer(root_value, data_buf, size);
     /* free json malloc*/
     json_value_free(root_value);
 }
 /**
  * Collect JSON alarm data
  * @param data_buf destinaiion buffer
  * @param size destination buffer size
  */
 void Application_Collect_Access_Data(ts_notify_task_queue_t data,
                                             char data_buf[], int32_t size){
     /* create root JSON object */
     JSON_Value *root_value = json_value_init_object();
     JSON_Object *root_object = json_value_get_object(root_value);
     /* create access array */
     JSON_Value *access_array_value = json_value_init_array();
     JSON_Array *access_array = json_value_get_array(access_array_value);
     /* create single access object */
     JSON_Value *access_item_value = json_value_init_object();
     JSON_Object *access_item = json_value_get_object(access_item_value);
     /* fill access item */
     json_object_set_string(access_item,  "deviceid", start_data.device_id);
     /* check access type */
     switch (data.accessType) {
         case ACCESS_NFC:
             json_object_set_string(access_item, "type", "NFC");
             break;
         case ACCESS_BUTTON:
             json_object_set_string(access_item, "type", "BUTTON");
             break;
         case ACCESS_TCPSERVER:
             json_object_set_string(access_item, "type", "TCPSERVER");
             break;
         case ACCESS_TCPCLIENT:
             json_object_set_string(access_item, "type", "TCPCLIENT");
             break;
         case ACCESS_BLE:
             json_object_set_string(access_item, "type", "BLE");
             break;
         default:
             json_object_set_string(access_item, "type", "UNKNOWN");
             break;
     }
     /* set uuid*/
     json_object_set_string(access_item,  "uuid",  data.accessUUID);
     /* set terminal mode */
     json_object_set_boolean(access_item, "isterminal", (device_settings.terminalMode == 222) ? 1 : 0);
     /* set granted mode */
     json_object_set_boolean(access_item, "isgranted", data.isgranted);
     /* set timestamp mode */
     json_object_set_number(access_item,  "timestamp", data.timeStamp);
     /* add access item to access array */
     json_array_append_value(access_array, access_item_value);
     /* set access array under key "access" in root */
     json_object_set_value(root_object, "accessLog", access_array_value);
     /* serialize to buffer */
     json_serialize_to_buffer(root_value, data_buf, size);
     /* free memory */
     json_value_free(root_value);
 }