#!/usr/bin/env python3
import sqlite3

def clear_mock_logs():
    # Veritabanına bağlan
    conn = sqlite3.connect('data.db')
    cursor = conn.cursor()
    
    print("Mock access log'lar temizleniyor...")
    
    # Mock device ID'leri ile log'ları sil
    mock_device_ids = ['TEST001', 'TEST002', 'TEST003']
    
    for device_id in mock_device_ids:
        cursor.execute('DELETE FROM access_logs WHERE device_id = ?', (device_id,))
        deleted_count = cursor.rowcount
        print(f"{device_id} için {deleted_count} log silindi")
    
    # Değişiklikleri kaydet
    conn.commit()
    conn.close()
    
    print("Mock access log'lar başarıyla temizlendi!")

if __name__ == "__main__":
    clear_mock_logs() 