#!/usr/bin/env python3
import sqlite3
import time
import random
from datetime import datetime, timedelta

def add_rs485_logs():
    # Veritabanına bağlan
    conn = sqlite3.connect('data.db')
    cursor = conn.cursor()
    
    # Mock veriler için hazırlık
    device_ids = ['1097BD2183D0', 'RS485_001', 'RS485_002', 'RS485_003', 'RS485_004']
    card_uuids = [
        'a1b2c3d4-e5f6-7890-abcd-ef1234567890',
        'b2c3d4e5-f6g7-8901-bcde-f23456789012',
        'c3d4e5f6-g7h8-9012-cdef-345678901234',
        'd4e5f6g7-h8i9-0123-defg-456789012345',
        'e5f6g7h8-i9j0-1234-efgh-567890123456',
        'f6g7h8i9-j0k1-2345-fghi-678901234567',
        'g7h8i9j0-k1l2-3456-ghij-789012345678',
        'h8i9j0k1-l2m3-4567-hijk-890123456789'
    ]
    
    # RS485 access type = 6
    access_type = 6
    
    print("100 mock RS485 access log ekleniyor...")
    
    # Son 7 gün içinde rastgele tarihler oluştur (daha yakın tarihler)
    end_time = datetime.now()
    start_time = end_time - timedelta(days=7)
    
    for i in range(100):
        # Rastgele veriler
        device_id = random.choice(device_ids)
        card_uuid = random.choice(card_uuids)
        is_granted = random.choice([True, False])
        
        # Rastgele timestamp (son 7 gün içinde)
        random_seconds = random.randint(0, int((end_time - start_time).total_seconds()))
        timestamp = int((end_time - timedelta(seconds=random_seconds)).timestamp())
        
        # Veritabanına ekle
        cursor.execute('''
            INSERT INTO access_logs (device_id, card_uuid, access_type, is_granted, timestamp)
            VALUES (?, ?, ?, ?, ?)
        ''', (device_id, card_uuid, access_type, 1 if is_granted else 0, timestamp))
        
        if (i + 1) % 10 == 0:
            print(f"{i + 1} RS485 log eklendi...")
    
    # Değişiklikleri kaydet
    conn.commit()
    conn.close()
    
    print("100 mock RS485 access log başarıyla eklendi!")

if __name__ == "__main__":
    add_rs485_logs() 