#!/usr/bin/env python3
import sqlite3
import time
import random
from datetime import datetime, timedelta

def add_mock_logs():
    # Veritabanına bağlan
    conn = sqlite3.connect('data.db')
    cursor = conn.cursor()
    
    # Mock veriler için hazırlık
    device_ids = ['1097BD2183D0', 'TEST001', 'TEST002', 'TEST003']
    card_uuids = [
        'a1b2c3d4-e5f6-7890-abcd-ef1234567890',
        'b2c3d4e5-f6g7-8901-bcde-f23456789012',
        'c3d4e5f6-g7h8-9012-cdef-345678901234',
        'd4e5f6g7-h8i9-0123-defg-456789012345',
        'e5f6g7h8-i9j0-1234-efgh-567890123456'
    ]
    access_types = [1, 2, 3, 4, 5]  # NFC, BUTTON, TCP SERVER, TCP CLIENT, BLE
    
    print("1000 mock access log ekleniyor...")
    
    # Son 30 gün içinde rastgele tarihler oluştur
    end_time = datetime.now()
    start_time = end_time - timedelta(days=30)
    
    for i in range(1000):
        # Rastgele veriler
        device_id = random.choice(device_ids)
        card_uuid = random.choice(card_uuids)
        access_type = random.choice(access_types)
        is_granted = random.choice([True, False])
        
        # Rastgele timestamp (son 30 gün içinde)
        random_seconds = random.randint(0, int((end_time - start_time).total_seconds()))
        timestamp = int((end_time - timedelta(seconds=random_seconds)).timestamp())
        
        # Veritabanına ekle
        cursor.execute('''
            INSERT INTO access_logs (device_id, card_uuid, access_type, is_granted, timestamp)
            VALUES (?, ?, ?, ?, ?)
        ''', (device_id, card_uuid, access_type, 1 if is_granted else 0, timestamp))
        
        if (i + 1) % 100 == 0:
            print(f"{i + 1} log eklendi...")
    
    # Değişiklikleri kaydet
    conn.commit()
    conn.close()
    
    print("1000 mock access log başarıyla eklendi!")

if __name__ == "__main__":
    add_mock_logs() 