# TCP Thread Sistemi - Kullanım Kılavuzu

## Genel Bakış

Bu sistem, cihazların TCP bağlantılarını yönetmek için thread tabanlı bir yapı kullanır. Sistem iki ana modda çalışır:

1. **TCP Server Modu**: Cihazlar 80 portundan bağlanır
2. **TCP Client Modu**: Sistem diğer cihazlara bağlanır

## Sistem Özellikleri

### 🔧 Ana Özellikler
- **Multi-thread TCP Server**: 80 portunda çalışır
- **Dinamik Client Bağlantıları**: TCP client cihazlarına otomatik bağlanma
- **Gerçek Zamanlı Durum Takibi**: Cihaz bağlantı durumlarını canlı izleme
- **JSON ve Text Mesaj Desteği**: Farklı veri formatlarını destekler
- **Otomatik Log Kaydı**: Gelen verileri veritabanına kaydeder

### 📊 Desteklenen Veri Formatları

#### JSON Formatı
```json
{
    "ad": "Kullanıcı Adı",
    "bolge": "Bölge Adı", 
    "gecis_turu": "ACCESS_TCPCLIENT",
    "notlar": "Ek bilgiler",
    "giris_durumu": "GIRIS_YAPILDI"
}
```

#### Basit Text Formatı
```
Merhaba, bu bir test mesajıdır
```

## Kurulum ve Çalıştırma

### 1. Uygulamayı Başlatma
```bash
python "from flask import Flask, jsonify.py"
```

### 2. Web Arayüzüne Erişim
- Tarayıcıda `http://localhost:5000` adresine gidin
- Admin paneline giriş yapın
- "Cihazlar" sekmesine gidin

## Cihaz Yönetimi

### Cihaz Ekleme
1. "Cihaz Ekle" butonuna tıklayın
2. Cihaz bilgilerini girin:
   - **Cihaz Adı**: Cihazın tanımlayıcı adı
   - **Seri Numarası**: Benzersiz seri numarası
   - **TCP Tipi**: Server veya Client seçin
   - **IP Adresi**: Client modunda IP adresi gerekli

### TCP Client Cihazlarına Bağlanma
1. Cihazlar listesinde TCP Client cihazını bulun
2. "Bağlan" butonuna tıklayın
3. Sistem otomatik olarak cihaza bağlanır
4. Bağlantı durumu yeşil gösterge ile belirtilir

### Mesaj Gönderme
1. Bağlı cihaz için "Mesaj" butonuna tıklayın
2. Modal pencerede mesajınızı yazın
3. "Gönder" butonuna tıklayın

## Test Etme

### Test Client Kullanımı
```bash
# Yerel test
python tcp_test_client.py localhost 80

# Uzak sunucu testi  
python tcp_test_client.py 192.168.1.100 80
```

### Test Komutları
```
json Merhaba Dünya    # JSON formatında mesaj gönder
text Test mesajı      # Basit text mesajı gönder
quit                  # Çıkış
```

## Sistem Mimarisi

### Thread Yapısı
```
Ana Uygulama (Flask)
├── TCP Server Thread (Port 80)
│   ├── Client Connection Thread 1
│   ├── Client Connection Thread 2
│   └── ...
├── TCP Client Thread 1 (Cihaz 1)
├── TCP Client Thread 2 (Cihaz 2)
└── ...
```

### Veri Akışı
```
Cihaz → TCP Server → Thread → Veri İşleme → Veritabanı
```

## Güvenlik Notları

### 🔒 Güvenlik Önlemleri
- Sadece yetkili kullanıcılar cihaz yönetimi yapabilir
- Bağlantı durumları gerçek zamanlı izlenir
- Hata durumlarında otomatik bağlantı kesme
- Log kayıtları ile audit trail

### ⚠️ Dikkat Edilecekler
- 80 portu için root yetkisi gerekebilir
- Firewall ayarlarını kontrol edin
- Network güvenliği için gerekli önlemleri alın

## Sorun Giderme

### Yaygın Sorunlar

#### 1. Port 80 Kullanımda
```bash
# Port kullanımını kontrol et
sudo netstat -tulpn | grep :80

# Gerekirse farklı port kullan
tcp_manager.start_server(port=8080)
```

#### 2. Bağlantı Hatası
- Cihaz IP adresini kontrol edin
- Network bağlantısını test edin
- Firewall ayarlarını kontrol edin

#### 3. Thread Hatası
- Sistem loglarını kontrol edin
- Uygulamayı yeniden başlatın
- Bellek kullanımını kontrol edin

### Debug Modu
```python
# Debug loglarını aktifleştir
logging.basicConfig(level=logging.DEBUG)
```

## API Endpoints

### Cihaz Durumu
```
GET /api/device/status
```

### Cihaz Bağlantısı
```
POST /device/connect/<device_id>
POST /device/disconnect/<device_id>
POST /device/send/<device_id>
```

## Performans Optimizasyonu

### 🚀 Öneriler
- Thread sayısını sistem kaynaklarına göre ayarlayın
- Düzenli bağlantı temizliği yapın
- Log dosyalarını periyodik olarak temizleyin
- Network bandwidth'ini izleyin

### 📈 Monitoring
- Bağlantı sayısını izleyin
- Mesaj throughput'unu takip edin
- Hata oranlarını kontrol edin
- Sistem kaynaklarını monitör edin

## Geliştirme

### Yeni Özellik Ekleme
1. `TCPConnectionManager` sınıfını genişletin
2. Yeni route'lar ekleyin
3. Frontend'i güncelleyin
4. Test edin

### Kod Yapısı
```
TCPConnectionManager
├── start_server()          # Ana server başlatma
├── connect_to_client_device()  # Client bağlantısı
├── send_to_client_device()     # Mesaj gönderme
└── stop()                 # Tüm bağlantıları durdurma
```

## Lisans
Bu proje MIT lisansı altında lisanslanmıştır. 